﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using BMS.Facade.Data;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Utils;
using DC = BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using System.ServiceModel;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.Cache;
using BMS.VistaIntegration.Data;
using BMS.ServicesWrapper.EVS;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.VistaWorker2.Writer;
using BMS.VistaWorker2.Writer.Implementation;
using InfoWorld.EVS.CTSMAPI;
using FC = BMS.Facade.Data;

namespace Import_VistaJob
{
    public class ADTProcessor
    {
        static VI.VistASite vistaSettings = null;        
        static ADTQuery adtQuery;        
        static IList<CDWithProperties> orderableItems = null;
        static IList<CD> orderableItemsTypes = null;
        private const string FormatDateTime = "MM/dd/yyyy HH:mm:ss";

        public static void ImportADTData(VI.VistASite vistaSite, string methodType, DateTime startDate, DateTime endDate)
        {
            vistaSettings = vistaSite;
            CodeFilterParametersWithProperty codeFilterParamWithProperties = new CodeFilterParametersWithProperty();
            codeFilterParamWithProperties.VocabularyDomain = FC.Util.Vocabulary.ADTOrderableItem.ToString();
            codeFilterParamWithProperties.Properties = new List<string>();
            codeFilterParamWithProperties.Properties.Add("IEN");
            codeFilterParamWithProperties.Properties.Add("OrderableItemType");
            //get ADT Orderable Items from EVS
            orderableItems = EVSFactory.InstanceWindows.GetCodesWithProperties(codeFilterParamWithProperties);
            orderableItemsTypes = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParametersWithProperty() { VocabularyDomain = FC.Util.Vocabulary.OrderableItemType.ToString() });
            DataRetrievalMethod? retrievalMethod = null;
            bool _isSuccess = true;
            if (methodType.Equals(DataRetrievalMethod.MDWS.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.MDWS;
            else if (methodType.Equals(DataRetrievalMethod.ODBC.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.ODBC;

            Tracer.TraceMessage(DateTime.Now + " start importing the ADTs");

            IWriterManager writerManager = new WriterManagerFactory().MakeWriter();
            writerManager.Open(new VistASite(vistaSettings.Id, vistaSettings.Name, vistaSettings.Number, vistaSettings.TimeZone, null));
            adtQuery = new ADTQuery(new VistASite(vistaSettings.Id, vistaSettings.Name, vistaSettings.Number, vistaSettings.TimeZone, null), orderableItems); 
            try
            {
                IVistAQuery query = Utils.GetVistASession(vistaSettings, retrievalMethod.Value).MakeQuery();
                var ois = BMS.Facade.FacadeUtil.GetOrderableItem(EVSFactory.InstanceWindows, vistaSettings.Name).Select(s => Utils.GetOrderableItemIen(s.code)).Distinct().ToArray();
                IList<BMS.Facade.Data.HospitalLocation> hospitalLocations = Utils.GetHospitalLocationsByVista(vistaSettings.Id);
                List<BMS.DataContracts.HospitalLocationAppointment> hlList = BMSFactory.BedManagerOperationsClientWindows.GetHospitalLocationsAppointment(null, Guid.Parse(vistaSettings.Id));
                var clincsIens = (from a in hospitalLocations
                                  where (from b in hlList select b.HospitalLocationId.extension).Contains(a.Id.extension, StringComparer.InvariantCultureIgnoreCase)
                                  select a.Ien).ToList();
                Tracer.TraceMessage("Loaded collections for orderableItems, hospital locations, discharge clinics");

                List<OrderAction> orderList = query.GetOrderActions(startDate, endDate, null, ois).ToList();
                Tracer.TraceMessage("Loaded orders " + orderList.Count);
                List<ScheduledAdmission> scheduledAdmissionList = query.GetScheduledAdmissions(startDate, DateTime.Now.AddYears(1), null).ToList();
                Tracer.TraceMessage("Loaded scheduled admissions " + scheduledAdmissionList.Count);
                List<PatientAppointment> appointmentList = query.GetPatientAppointments(startDate, null, null, clincsIens).ToList();
                Tracer.TraceMessage("Loaded patient appointments " + appointmentList.Count);
                List<PatientMovement> movementList = query.GetPatientMovements(startDate, endDate).ToList();
                Tracer.TraceMessage("Loaded patient movements " + movementList.Count);
                long movementIenMin = -1;
                if (movementList != null && movementList.Count > 0)
                {
                    foreach (PatientMovement pm in movementList)
                    {
                        if (long.TryParse(pm.IEN, out movementIenMin))
                            break;
                    }
                }
                List<AdmittedPatient> admittedPatients = query.GetAdmittedPatients(movementIenMin.ToString()).ToList();
                Tracer.TraceMessage("Loaded admitted patients " + admittedPatients.Count);
                List<PatientMovement> movements = new List<PatientMovement>();
                foreach (AdmittedPatient patient in admittedPatients)
                {
                    Tracer.TraceMessage("getting movements for admissionIen:" + patient.AdmissionIen);
                    movements.AddRange(query.GetPatientMovementsForAdmission(patient.AdmissionIen));
                }
                List<PatientMovement> missingMovements = new List<PatientMovement>();
                long currentAdmissionIen = -1;
                foreach (PatientMovement obj in movementList)
                {
                    if (long.TryParse(obj.CurrentAdmissionIen, out currentAdmissionIen))
                    {
                        if (currentAdmissionIen < movementIenMin)
                        {
                            if (missingMovements.Where(a => a.IEN == obj.CurrentAdmissionIen).FirstOrDefault() == null)
                            {
                                Tracer.TraceMessage("getting movements for missing admission with ien:" + obj.CurrentAdmissionIen);
                                missingMovements.AddRange(query.GetPatientMovementsForAdmission(obj.CurrentAdmissionIen));
                            }
                        }
                    }
                    else
                    {
                        if (movementList.Where(a => a.IEN.Equals(obj.CurrentAdmissionIen)).FirstOrDefault() == null)
                        {
                            if (missingMovements.Where(a => a.IEN == obj.CurrentAdmissionIen).FirstOrDefault() == null)
                            {
                                Tracer.TraceMessage("getting movements for missing admission with ien:" + obj.CurrentAdmissionIen);
                                missingMovements.AddRange(query.GetPatientMovementsForAdmission(obj.CurrentAdmissionIen));
                            }
                        }
                    }
                }
                foreach (PatientMovement pm in movements)
                {
                    if (movementList.Where(a => a.IEN == pm.IEN).FirstOrDefault() == null)
                        movementList.Add(pm);
                }
                foreach (PatientMovement pm in missingMovements)
                {
                    if (movementList.Where(a => a.IEN == pm.IEN).FirstOrDefault() == null)
                        movementList.Add(pm);
                }
                movementList = movementList.OrderBy(a => a.EnteredOnDateTime).ToList();
                Tracer.TraceMessage("Loaded movements for admitted patients " + movements.Count);
                string ien = null;
                DC.VistaIntegrationLog vistaIntegrationLog = null;
                Tracer.TraceMessage("Start processing orders...");
                List<DC.VistaIntegrationLog> alreadyExistsADTs = Utils.GetAlreadyExistsVistaIntegrationLogs(orderList.Select<OrderAction, DC.VistaIntegrationLog>(a => VistaIntegrationLogFactory.MakeOrderActionLog(a)).Select<DC.VistaIntegrationLog, string>(b => b.Ien).ToList(), DC.VistaFiles.Order, vistaSite.Name);
                foreach (OrderAction obj in orderList)
                {
                    ien = string.Format("{0}_{1}", obj.OrderId, obj.DateTimeOrdered.ToString(FormatDateTime));
                    if (alreadyExistsADTs.Where(a => a.Ien.Equals(ien)).FirstOrDefault() == null)
                    {
                        vistaIntegrationLog = VistaIntegrationLogFactory.MakeOrderActionLog(obj);
                        TimeZoneUtil.ConvertObjectDates(obj, false, vistaSettings.TimeZone);
                        ProcessOrder(obj, vistaIntegrationLog);
                    }
                    else
                        Tracer.TraceMessage("Order with ien " + ien + " is already processed.");
                }
                Tracer.TraceMessage("Start processing patient movements...");
                alreadyExistsADTs = Utils.GetAlreadyExistsVistaIntegrationLogs(movementList.Select<PatientMovement, string>(a => a.IEN).ToList(), DC.VistaFiles.PatientMovement, vistaSite.Name);
                foreach (PatientMovement obj in movementList)
                {
                    if (alreadyExistsADTs.Where(a => a.Ien.Equals(obj.IEN)).FirstOrDefault() == null)
                    {
                        TimeZoneUtil.ConvertObjectDates(obj, false, vistaSettings.TimeZone);
                        ProcessMovement(obj);
                    }
                    else
                        Tracer.TraceMessage("Patient movement with ien " + obj.IEN + " is already processed.");
                }
                Tracer.TraceMessage("Start processing appointments...");
                alreadyExistsADTs = Utils.GetAlreadyExistsVistaIntegrationLogs(appointmentList.Select<PatientAppointment, DC.VistaIntegrationLog>(a => VistaIntegrationLogFactory.MakePatientAppointmentLog(a)).Select<DC.VistaIntegrationLog, string>(b => b.Ien).ToList(), DC.VistaFiles.PatientAppointment, vistaSite.Name);
                foreach (PatientAppointment obj in appointmentList)
                {
                    ien = string.Format("{0}_{1}", obj.Patient.IEN, obj.AppointmentDateTime.ToString(FormatDateTime));
                    if (alreadyExistsADTs.Where(a => a.Ien.Equals(ien)).FirstOrDefault() == null)
                    {
                        vistaIntegrationLog = VistaIntegrationLogFactory.MakePatientAppointmentLog(obj);
                        Tracer.TraceMessage("Processing patient appointment with date: " + obj.DateAppointmentMade.ToString());
                        TimeZoneUtil.ConvertObjectDates(obj, false, vistaSettings.TimeZone);
                        adtQuery.InsertPatientAppointment(obj, vistaIntegrationLog);
                    }
                    else
                        Tracer.TraceMessage("Patient appointment with ien " + ien + " is already processed.");
                }
                Tracer.TraceMessage("Start processing scheduled admissions...");
                alreadyExistsADTs = Utils.GetAlreadyExistsVistaIntegrationLogs(scheduledAdmissionList.Select<ScheduledAdmission, string>(a => a.IEN).ToList(), DC.VistaFiles.ScheduledAdmission, vistaSite.Name);
                foreach (ScheduledAdmission obj in scheduledAdmissionList)
                {
                    if (alreadyExistsADTs.Where(a => a.Ien.Equals(obj.IEN)).FirstOrDefault() == null)
                    {
                        Tracer.TraceMessage("Processing scheduled admission with ien: " + obj.IEN);
                        TimeZoneUtil.ConvertObjectDates(obj, false, vistaSettings.TimeZone);
                        adtQuery.InsertScheduledAdmission(obj);
                    }
                    else
                        Tracer.TraceMessage("Scheduled admission with ien " + obj.IEN + " is already processed.");
                }

                //ProcessPatientsUpdate(query);
            }
            catch (FaultException<BMS.FaultContracts.VistAException> e)
            {
                _isSuccess = false;
                Tracer.TraceException(e);
            }
            finally
            {
                writerManager.Close();
                Utils.InsertVistaOperation(vistaSettings.Id, "16", endDate);
                GlobalConnections.CloseConnections();
            }
            if (_isSuccess)
            {
                Tracer.TraceMessage("Import ADT succeeded.");
                Console.WriteLine("Import ADT succeeded.");
            }
            
        }

        private static void ProcessOrder(OrderAction obj, DC.VistaIntegrationLog vistaIntegrationLog)
        {
            IList<CDWithProperties> cdpList = Utils.GetOrderableItem(obj.Order.OrderOrderableItemIds, vistaSettings.Name, orderableItems);
            string orderType = null;
            if (cdpList != null && cdpList.Count > 0)
                orderType = Utils.GetOrderType(cdpList[0], orderableItemsTypes);           

            if (obj.Order.OrderOrderableItemIds != null && obj.Order.OrderOrderableItemIds.Count > 0)
            {
                if (String.IsNullOrEmpty(orderType))
                    Tracer.TraceMessage("processing order with ien " + obj.OrderId + ", with orderable item: " + obj.Order.OrderOrderableItemIds[0] + " that has an unknown type and with text: " + obj.OrderText);
                else
                    Tracer.TraceMessage("processing order with ien " + obj.OrderId + ", with orderable item: " + obj.Order.OrderOrderableItemIds[0] + " and type: " + orderType + " and with text: " + obj.OrderText);
            }
            else
                Tracer.TraceMessage("processing order with ien " + obj.OrderId + ", without orderable item and with text: " + obj.OrderText);            

            if (!string.IsNullOrEmpty(orderType))
            {
                if (orderType.Equals(Constants.ORDERABLE_ITEM_TYPE_ADMISSION, StringComparison.InvariantCultureIgnoreCase))
                {
                    adtQuery.InsertAdmissionOrder(obj, vistaIntegrationLog);
                    Tracer.TraceMessage("processed an admission order");
                }
                else if (orderType.Equals(Constants.ORDERABLE_ITEM_TYPE_TRANSFER, StringComparison.InvariantCultureIgnoreCase))
                {
                    adtQuery.InsertTransferOrder(obj, vistaIntegrationLog);
                    Tracer.TraceMessage("processed a transfer order");
                }
                else if (orderType.Equals(Constants.ORDERABLE_ITEM_TYPE_DISCHARGE, StringComparison.InvariantCultureIgnoreCase))
                {
                    adtQuery.InsertDischargeOrder(obj, vistaIntegrationLog);
                    Tracer.TraceMessage("processed a discharge order");
                }
            }
            else
            {
                if (!string.IsNullOrEmpty(obj.OrderText) && ((obj.OrderText.ToLower().Contains("anticipate") || obj.OrderText.ToLower().Contains("planned")) && obj.OrderText.ToLower().Contains("discharge")))
                {
                    adtQuery.InsertDischargeOrder(obj, vistaIntegrationLog);
                    Tracer.TraceMessage("processed an anticipated discharge order");
                }
                else
                    Tracer.TraceMessage("ERROR: Order with Id: " + obj.OrderId + " has no type! It has no orderable items and is not an anticipated discharge order");                
            }            
        }

        private static void ProcessMovement(PatientMovement obj)
        {            
            decimal transaction = 0;            
            decimal.TryParse(obj.TransactionTypeId, out transaction);                        
            if (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX)
            {
                if (string.IsNullOrEmpty(obj.WardLocationId) && string.IsNullOrEmpty(obj.RoomBedId))
                {
                    Tracer.TraceMessage("Admission with ien: " + obj.IEN + "has no ward.");
                    return;
                }
                Tracer.TraceMessage("Processing an admission with ien: " + obj.IEN);
                adtQuery.InsertAdmissionEvent(obj);
            }
            else if (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX)                        
            {
                if (string.IsNullOrEmpty(obj.WardLocationId) && string.IsNullOrEmpty(obj.RoomBedId))
                {
                    Tracer.TraceMessage("Transfer with ien: " + obj.IEN + "has no ward.");
                    return;
                }
                Tracer.TraceMessage("Processing a transfer with ien: " + obj.IEN + " and current admission ien:" + (obj.CurrentAdmissionIen != null ? obj.CurrentAdmissionIen : "null"));                
                List<string> places = Utils.GetWardBedFromAdmission(obj.CurrentAdmissionIen, vistaSettings.Id);
                if (places != null && places.Count == 2)
                    adtQuery.InsertTransferEvent(obj, places[1], places[0]);
                else
                    adtQuery.InsertTransferEvent(obj, null, null);
            }
            else if (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX)
            {
                Tracer.TraceMessage("Processing a discharge with ien: " + obj.IEN + " and current admission ien:" + (obj.CurrentAdmissionIen != null ? obj.CurrentAdmissionIen : "null"));
                List<string> places = Utils.GetWardBedFromAdmission(obj.CurrentAdmissionIen, vistaSettings.Id);
                if (places != null && places.Count == 2)
                {
                    obj.WardLocationId = places[0];
                    obj.RoomBedId = places[1];
                }
                adtQuery.InsertDischargeEvent(obj);
            }
            else if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX) 
                && (string.IsNullOrEmpty(obj.RoomBedId) || string.IsNullOrEmpty(obj.WardLocationId)))
            {
                Tracer.TraceMessage("Processing a specialty transfer with ien: " + obj.IEN + " and current admission ien:" + (obj.CurrentAdmissionIen != null ? obj.CurrentAdmissionIen : "null"));
                adtQuery.InsertSpecialtyTransfer(obj);               
            }
        }

        private static void ProcessPatientsUpdate(IVistAQuery query)
        {
            try
            {
                List<Person> persons = Utils.GetPersonsByVista(vistaSettings.Id);
                Tracer.TraceMessage("Update attending for patients: Begin get admitted patients from Vista");
                List<BMS.VistaIntegration.Data.Patient> vistaPatients = query.GetAdmittedPatientsForUpdate().ToList();
                Tracer.TraceMessage("Update attending for patients: End get admitted patients from Vista. Count: " + vistaPatients.Count.ToString());
                List<NewPerson> attendings = vistaPatients.Where(a => a.AttendingPhysician != null).Select<BMS.VistaIntegration.Data.Patient, NewPerson>(a => a.AttendingPhysician).Distinct().ToList();
                //insert persons if not found in EIS
                Dictionary<string, string> names = null;
                Person insertedPerson = null;
                foreach (NewPerson person in attendings)
                {
                    if (persons.Where(a => a.Ien == person.IEN).FirstOrDefault() == null)
                    {
                        names = Utilities.SplitPersonFullName(person.Name);
                        insertedPerson = new FC.Person()
                        {
                            Ien = person.IEN,
                            LastName = names[Constants.PERSON_LAST_NAME],
                            MiddleName = names[Constants.PERSON_MIDDLE_NAME],
                            FirstName = names[Constants.PERSON_FIRST_NAME],
                            VistaSite = new II(Utils.DomainId, vistaSettings.Id)
                        };
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CreateMedicalPerson(insertedPerson);
                        persons.Add(insertedPerson);
                    }
                }
                Utils.SaveAttendingForPatients(vistaPatients, persons);
                Tracer.TraceMessage("Update attending for patients: Update finished!");
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("Exception on updating attending physicians:");
                Tracer.TraceException(ex);
            }
        }
    }    
}
